/**
  Copyright (c) 2006 Freescale Semiconductor
  Freescale Confidential Proprietary
  \file         Interrupts.c	
  \brief    	This file is used to declare the interrupt vectors as defined
                by the internal C Coding Standard.
  \author   	Freescale Semiconductor
  \author       Antonio Ramos Salido Maurer
  \author   	Guadalajara Applications Laboratory RTAC Americas
  \version      0.1
  \date     	3/Nov/2006
  \warning

  * History:
  
*/
/*****************************************************************************/

#include "Interrupts.h"

/*****************************************************************************/

interrupt void dummyisr(void){
    for(;;)
        ; /* Empty Body */
}

/*****************************************************************************/
void (* const _vect[])() @ 0xFFC0 =   /* Interrupt table */
{ 
    dummyisr,   /* <none>                   */
    dummyisr,   /* <none>                   */
    dummyisr,   /* <none>                   */
    dummyisr,   /* <none>                   */
    dummyisr,   /* <none>                   */
    dummyisr,   /* <none>                   */
    dummyisr,   /* Real Time interrupt      */
    vfnI2CIsr,  /* IIC                      */
    dummyisr,   /* ADC                      */
    vfnKBIIsr,  /* Keyboard pins            */
    dummyisr,   /* SCI2 transmit            */
    dummyisr,   /* SCI2 receive             */
    dummyisr,   /* SCI2 error               */
    dummyisr,   /* SCI1 transmit            */
    dummyisr,   /* SCI1 receive             */
    dummyisr,   /* SCI1 error               */
    vfnSPIIsr,  /* SPI                      */
    dummyisr,   /* TPM2 overflow            */
    dummyisr,   /* TPM2 channel 4           */
    dummyisr,   /* TPM2 channel 3           */
    dummyisr,   /* TPM2 channel 2           */
    dummyisr,   /* TPM2 channel 1           */
    dummyisr,   /* TPM2 channel 0           */
    dummyisr,   /* TPM1 overflow            */
    dummyisr,   /* TPM1 channel 2           */
    dummyisr,   /* TPM1 channel 1           */
    dummyisr,   /*/TPM1 channel 0           */
    dummyisr,   /* ICG                      */
    dummyisr,   /* Low-voltage detect       */
    dummyisr,   /* IRQ                      */
    dummyisr,   /* SWI                      */
    _Startup    /* RESET                    */
};

/*****************************************************************************/

